#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7BpsMessage
	{
		#region Variables & Setup

		private const string CARRIAGE_RETURN = "\x0D";

		private static string _hl7Message;

		HL7BpsMessage _bpsMessage;

		static Messages_HL7BpsMessage()
		{
			_hl7Message = string.Concat(
				"MSH^~|\\&^VBECS^VBECS^WBC^589^20080523012526-0500^^BPS~O29^VBECS8052301267749^T^2.5^^^AL^AL", 
				CARRIAGE_RETURN,
				"PID^^5890055542V264787^412820^^SIMPSON~ZLWYNLK~^^19120229^M^^^^^^^^^^^234560184",
				CARRIAGE_RETURN,
				"PV1^^O^VBEC COLUMBIA OUTP~~^^^^^^^", 
				CARRIAGE_RETURN,
				"ORC^SC^22179387~OR^^^^^^^^^^53333~USER~ONE~", 
				CARRIAGE_RETURN,
				"BPO^1^1~RED BLOOD CELLS^~^2", 
				CARRIAGE_RETURN,
				"BPX^1^RS^P^20080523012526-0500^123444444^04210^^^^^ABORH~O Neg^^20080531065900-0500^2^^^b2754dd8-12d1-4a8c-b4c7-e1f9da325b24", 
				CARRIAGE_RETURN,
				"OBX^^CE^ASR^^Neg",
				CARRIAGE_RETURN,
				"OBX^^CE^ABO^^O",  
				CARRIAGE_RETURN,
				"OBX^^CE^Rh^^POS",
				CARRIAGE_RETURN );
		}

		[SetUp]
		public void SetUp()
		{
			_bpsMessage = new HL7BpsMessage( _hl7Message );
		}

		#endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7BpsMessage bpsMessage = new HL7BpsMessage( _hl7Message );
			//
			Assert.IsTrue( bpsMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7BpsMessage bpsMessage = new HL7BpsMessage( null );
			//
			Assert.IsTrue( bpsMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _bpsMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

		[Test]
		public void GetMessageControlID_Pass()
		{
			Assert.IsNotNull( _bpsMessage.GetMessageControlID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _bpsMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _bpsMessage.IsResponseRequired() == true );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}

		#endregion

		#region Properties

		[Test]
		public void Delimiters_Pass()
		{
			Assert.IsNotNull( _bpsMessage.Delimiters );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Delimiters_Fail()
		{
		}


		[Test]
		public void MessageType_Pass()
		{
			Assert.IsNotNull( _bpsMessage.MessageType );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageType_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.IsNotNull( _bpsMessage.Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

		[Test]
		public void MessageControlID_Pass()
		{
			Assert.IsNotNull( _bpsMessage.MessageControlID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageControlID_Fail()
		{
		}

		[Test]
		public void MSH_Pass()
		{
			Assert.IsNotNull( _bpsMessage.MSH );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSH_Fail()
		{
		}

		[Test]
		public void PID_Pass()
		{
			Assert.IsNotNull( _bpsMessage.PID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PID_Fail()
		{
		}

		[Test]
		public void PV1_Pass()
		{
			Assert.IsNotNull( _bpsMessage.PV1 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PV1_Fail()
		{
		}

		[Test]
		public void ORC_Pass()
		{
			Assert.IsNotNull( _bpsMessage.ORC );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ORC_Fail()
		{
		}

		[Test]
		public void BPO_Pass()
		{
			Assert.IsNotNull( _bpsMessage.BPO );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BPO_Fail()
		{
		}

		[Test]
		public void BPX_Pass()
		{
			Assert.IsNotNull( _bpsMessage.BPX );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BPX_Fail()
		{
		}

		[Test]
		public void OBX_Pass()
		{
			Assert.IsNotNull( _bpsMessage.OBX );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OBX_Fail()
		{
		}

		
		#endregion
	}
}
#endif